/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2006                         */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.C:  Device Description for AT49BV322D (16-bit Bus) flash  */
/*               used on the NXP LPC1850 validation board              */
/*                                                                     */
/***********************************************************************/

#include "..\FlashOS.H"        // FlashOS Structures


struct FlashDevice const FlashDevice  =  {
   FLASH_DRV_VERS,             // Driver Version, do not modify!
   "AT49BV322D @ LPC4350 Validation",         // Device Name
   EXT16BIT,                   // Device Type
   0x1C000000,                 // Device Start Address when flash is connected to CS0 on LPC1850
   0x400000,                   // Device Size in Bytes (4MB)
   1024,                       // Programming Page Size
   0,                          // Reserved, must be 0
   0xFF,                       // Initial Content of Erased Memory
   100,                        // Program Page Timeout 100 mSec
   1000,                       // Erase Sector Timeout 1000 mSec

// Specify Size and Address of Sectors
   0x02000, 0x000000,          // Sector Size  8kB (8 Sectors)
   0x10000, 0x010000,          // Sector Size 64kB (63 Sectors)
   SECTOR_END
};
